import{Fragment,h}from"@stencil/core";import{__}from"@wordpress/i18n";import{addQueryArgs}from"@wordpress/url";import apiFetch from"../../../../functions/fetch";import{onFirstVisible}from"../../../../functions/lazy";import{intervalString}from"../../../../functions/price";import{formatTaxDisplay}from"../../../../functions/tax";import{getFeaturedProductMediaAttributes}from"../../../../functions/media";export class ScOrder{constructor(){this.orderId=void 0,this.customerIds=void 0,this.heading=void 0,this.order=void 0,this.purchases=void 0,this.loading=void 0,this.busy=void 0,this.error=void 0}componentDidLoad(){onFirstVisible(this.el,(()=>{this.fetchOrder(),this.fetchDownloads()}))}async fetchOrder(){try{this.loading=!0,await this.getOrder()}catch(e){console.error(this.error),this.error=(null==e?void 0:e.message)||__("Something went wrong","surecart")}finally{this.loading=!1}}async fetchDownloads(){try{this.busy=!0,this.purchases=await apiFetch({path:addQueryArgs("surecart/v1/purchases",{expand:["product","product.downloads","download.media"],order_ids:[this.orderId],customer_ids:this.customerIds,downloadable:!0})})}catch(e){console.error(this.error),this.error=(null==e?void 0:e.message)||__("Something went wrong","surecart")}finally{this.busy=!1}}async getOrder(){this.order=await apiFetch({path:addQueryArgs(`surecart/v1/orders/${this.orderId}`,{expand:["checkout","checkout.line_items","line_item.price","line_item.fees","line_item.variant","variant.image","price.product","checkout.manual_payment_method","checkout.payment_method","checkout.selected_shipping_choice","shipping_choice.shipping_method","payment_method.card","payment_method.payment_instrument","payment_method.paypal_account","payment_method.bank_account","checkout.discount","discount.promotion","checkout.charge"]})})}renderLoading(){return h("sc-flex",{flexDirection:"column",style:{gap:"1em"}},h("sc-skeleton",{style:{width:"20%",display:"inline-block"}}),h("sc-skeleton",{style:{width:"60%",display:"inline-block"}}),h("sc-skeleton",{style:{width:"40%",display:"inline-block"}}))}renderEmpty(){return h("sc-empty",{icon:"shopping-bag"},__("Order not found.","surecart"))}renderContent(){var e,t,r,i,o,n,l,s,c,a,d,u,v;if(this.loading)return this.renderLoading();if(!(null===(e=this.order)||void 0===e?void 0:e.id))return this.renderEmpty();const p=null===(t=this.order)||void 0===t?void 0:t.checkout,m=null===(r=null==p?void 0:p.selected_shipping_choice)||void 0===r?void 0:r.shipping_method,y=null==m?void 0:m.name;return h(Fragment,null,((null===(i=null==p?void 0:p.line_items)||void 0===i?void 0:i.data)||[]).map((e=>{var t,r,i,o,n,l,s,c;const{url:a,title:d,alt:u}=getFeaturedProductMediaAttributes(null===(t=null==e?void 0:e.price)||void 0===t?void 0:t.product,null==e?void 0:e.variant);return h("sc-product-line-item",{key:e.id,imageUrl:a,imageAlt:u,imageTitle:d,name:null===(i=null===(r=null==e?void 0:e.price)||void 0===r?void 0:r.product)||void 0===i?void 0:i.name,priceName:null===(o=null==e?void 0:e.price)||void 0===o?void 0:o.name,variantLabel:((null==e?void 0:e.variant_options)||[]).filter(Boolean).join(" / ")||null,editable:!1,removable:!1,quantity:e.quantity,amount:e.subtotal_amount,currency:null===(n=null==e?void 0:e.price)||void 0===n?void 0:n.currency,trialDurationDays:null===(l=null==e?void 0:e.price)||void 0===l?void 0:l.trial_duration_days,interval:intervalString(null==e?void 0:e.price),scratchAmount:null==e?void 0:e.scratch_amount,setupFeeTrialEnabled:null===(s=null==e?void 0:e.price)||void 0===s?void 0:s.setup_fee_trial_enabled,fees:null===(c=null==e?void 0:e.fees)||void 0===c?void 0:c.data})})),h("sc-divider",{style:{"--spacing":"var(--sc-spacing-x-small)"}}),h("sc-line-item",null,h("span",{slot:"description"},__("Subtotal","surecart")),h("sc-format-number",{slot:"price",style:{"font-weight":"var(--sc-font-weight-semibold)",color:"var(--sc-color-gray-800)"},type:"currency",currency:null==p?void 0:p.currency,value:null==p?void 0:p.subtotal_amount})),!!(null==p?void 0:p.proration_amount)&&h("sc-line-item",null,h("span",{slot:"description"},__("Proration","surecart")),h("sc-format-number",{slot:"price",style:{"font-weight":"var(--sc-font-weight-semibold)",color:"var(--sc-color-gray-800)"},type:"currency",currency:null==p?void 0:p.currency,value:null==p?void 0:p.proration_amount})),!!(null==p?void 0:p.applied_balance_amount)&&h("sc-line-item",null,h("span",{slot:"description"},__("Applied Balance","surecart")),h("sc-format-number",{slot:"price",style:{"font-weight":"var(--sc-font-weight-semibold)",color:"var(--sc-color-gray-800)"},type:"currency",currency:null==p?void 0:p.currency,value:null==p?void 0:p.applied_balance_amount})),!!(null==p?void 0:p.discounts)&&h("sc-line-item",null,h("span",{slot:"description"},__("Discount","surecart")),h("sc-format-number",{slot:"price",style:{"font-weight":"var(--sc-font-weight-semibold)",color:"var(--sc-color-gray-800)"},type:"currency",currency:null==p?void 0:p.currency,value:null==p?void 0:p.discounts})),!!(null===(n=null===(o=null==p?void 0:p.discount)||void 0===o?void 0:o.promotion)||void 0===n?void 0:n.code)&&h("sc-line-item",null,h("span",{slot:"description"},__("Discount","surecart"),h("br",null),h("sc-tag",{type:"success"},__("Coupon:","surecart")," ",null===(s=null===(l=null==p?void 0:p.discount)||void 0===l?void 0:l.promotion)||void 0===s?void 0:s.code)),h("sc-format-number",{slot:"price",style:{"font-weight":"var(--sc-font-weight-semibold)",color:"var(--sc-color-gray-800)"},type:"currency",currency:null==p?void 0:p.currency,value:null==p?void 0:p.discount_amount})),!!(null==p?void 0:p.shipping_amount)&&h("sc-line-item",null,h("span",{slot:"description"},`${__("Shipping","surecart")} ${y?`(${y})`:""}`),h("sc-format-number",{slot:"price",style:{"font-weight":"var(--sc-font-weight-semibold)",color:"var(--sc-color-gray-800)"},type:"currency",currency:null==p?void 0:p.currency,value:null==p?void 0:p.shipping_amount})),!!(null==p?void 0:p.tax_amount)&&h("sc-line-item",null,h("span",{slot:"description"},formatTaxDisplay(null==p?void 0:p.tax_label)," (",null==p?void 0:p.tax_percent,"%)"),h("sc-format-number",{slot:"price",style:{"font-weight":"var(--sc-font-weight-semibold)",color:"var(--sc-color-gray-800)"},type:"currency",currency:null==p?void 0:p.currency,value:null==p?void 0:p.tax_amount})),h("sc-divider",{style:{"--spacing":"var(--sc-spacing-x-small)"}}),h("sc-line-item",{style:{width:"100%","--price-size":"var(--sc-font-size-x-large)"}},h("span",{slot:"title"},__("Total","surecart")),h("span",{slot:"price"},h("sc-format-number",{type:"currency",currency:null==p?void 0:p.currency,value:null==p?void 0:p.total_amount})),h("span",{slot:"currency"},null==p?void 0:p.currency)),(null==p?void 0:p.amount_due)!==(null==p?void 0:p.total_amount)&&h("sc-line-item",{style:{width:"100%","--price-size":"var(--sc-font-size-x-large)"}},h("span",{slot:"title"},__("Amount Due","surecart")),h("span",{slot:"price"},h("sc-format-number",{type:"currency",currency:null==p?void 0:p.currency,value:null==p?void 0:p.amount_due})),h("span",{slot:"currency"},null==p?void 0:p.currency)),!!(null==p?void 0:p.charge)&&h("sc-line-item",{style:{width:"100%","--price-size":"var(--sc-font-size-x-large)"}},h("span",{slot:"title"},__("Amount Paid","surecart")),h("span",{slot:"price"},h("sc-format-number",{type:"currency",currency:null===(c=null==p?void 0:p.charge)||void 0===c?void 0:c.currency,value:(null===(a=null==p?void 0:p.charge)||void 0===a?void 0:a.amount)?(null===(d=null==p?void 0:p.charge)||void 0===d?void 0:d.amount)-(null===(u=null==p?void 0:p.charge)||void 0===u?void 0:u.refunded_amount):0})),h("span",{slot:"currency"},null===(v=null==p?void 0:p.charge)||void 0===v?void 0:v.currency)))}render(){var e,t,r,i,o,n,l;const s=null===(e=null==this?void 0:this.order)||void 0===e?void 0:e.checkout,c=null==s?void 0:s.manual_payment_method;return h("sc-spacing",{style:{"--spacing":"var(--sc-spacing-large)"}},h("sc-dashboard-module",{error:this.error},h("span",{slot:"heading"},this.loading?h("sc-skeleton",{style:{width:"120px"}}):`#${null===(t=null==this?void 0:this.order)||void 0===t?void 0:t.number}`),!this.loading&&!(null==s?void 0:s.live_mode)&&h("sc-tag",{type:"warning",slot:"end"},__("Test Mode","surecart")),!!(null==c?void 0:c.name)&&!!(null==c?void 0:c.instructions)&&h("sc-order-manual-instructions",{manualPaymentTitle:null==c?void 0:c.name,manualPaymentInstructions:null==c?void 0:c.instructions}),h("sc-card",{"no-padding":!this.loading},this.loading?this.renderLoading():h(Fragment,null,h("sc-stacked-list",null,h("sc-stacked-list-row",{style:{"--columns":"2"}},h("div",null,__("Order Status","surecart")),h("sc-order-status-badge",{status:null===(r=null==this?void 0:this.order)||void 0===r?void 0:r.status})),h("sc-stacked-list-row",{style:{"--columns":"2"}},h("div",null,__("Date","surecart")),h("sc-format-date",{type:"timestamp",date:null===(i=this.order)||void 0===i?void 0:i.created_at,month:"short",day:"numeric",year:"numeric"})),h("sc-stacked-list-row",{style:{"--columns":"2"}},h("div",null,__("Payment Method","surecart")),h("sc-payment-method",{paymentMethod:null==s?void 0:s.payment_method})),h("div",{class:"order__row"},this.renderContent()))))),(null===(o=this.order)||void 0===o?void 0:o.statement_url)&&h("sc-button",{type:"primary",href:null===(n=this.order)||void 0===n?void 0:n.statement_url,target:"_blank"},h("sc-icon",{name:"inbox",slot:"prefix"}),__("Download Receipt/Invoice","surecart")),!!(null===(l=this.purchases)||void 0===l?void 0:l.length)&&h("sc-purchase-downloads-list",{heading:__("Downloads","surecart"),purchases:this.purchases}))}static get is(){return"sc-order"}static get encapsulation(){return"shadow"}static get originalStyleUrls(){return{$:["sc-order.scss"]}}static get styleUrls(){return{$:["sc-order.css"]}}static get properties(){return{orderId:{type:"string",mutable:!1,complexType:{original:"string",resolved:"string",references:{}},required:!1,optional:!1,docs:{tags:[],text:""},attribute:"order-id",reflect:!1},customerIds:{type:"unknown",mutable:!1,complexType:{original:"string[]",resolved:"string[]",references:{}},required:!1,optional:!1,docs:{tags:[],text:""}},heading:{type:"string",mutable:!1,complexType:{original:"string",resolved:"string",references:{}},required:!1,optional:!1,docs:{tags:[],text:""},attribute:"heading",reflect:!1}}}static get states(){return{order:{},purchases:{},loading:{},busy:{},error:{}}}static get elementRef(){return"el"}}